/*****************************************************************
File:         BMC21M041_TX.ino
Description:  Use with BMC23M041_RX.ino.
              By pressing the button, the motor rotation and LED lights can be controlled:
              KEY1:motor run
              KEY2:motor stop
              KEY3:LED toggle
              KEY4:LED off
***********************************************************/
#include "BM2102-9x-1.h"
#include <BMK52M134.h>

BM2102_9x_1 BMC21(&Serial1); //BMC21M041,connect to BMCOM1
BMK52M134 BMK52(25,&Wire2);  //BMK52M134,connect to BMCOM2
uint8_t keyValue[5] = {0};

void setup()
{
  Serial.begin(9600);                                                      
  BMC21.begin(RF_433_92MHz);
  BMK52.begin();
  Serial.println("setup OK");                                                                                                                                                                                                                                
}

void loop()
{  
   if(BMK52.getINT() == 0)
   {
     keyValue[0] =0 ;
     BMK52.getKeyValueArray(keyValue);
     Serial.println(keyValue[0],HEX);
     switch(keyValue[0])
     {
        case 0x01: //key1 pressed
             motorRun();
             Serial.println("motorRun");
             break;
        case 0x02: //key2 pressed
             motorStop();
             Serial.println("motorStop");
             break;
        case 0x04: //key3 pressed
             ledON();
             Serial.println("ledON");
             break;
        case 0x08: //key4 pressed
             ledOFF();
             Serial.println("ledOFF");
             break;
        default:
             break;
     }
   }
}

void writeByte(uint8_t sendData)
{
  if(!BMC21.isRFbusy()) //Determine if the keys are pressed and whether the RF is idle
  {
    BMC21.beginTransmission(sendData,1);
  } 
}
void motorRun()
{
  writeByte(0x01);
}
void motorStop()
{
  writeByte(0x02);
}
void ledON()
{
  writeByte(0x04);
}
void ledOFF()
{
  writeByte(0x08);
}
